/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using Borland.Eco.Handles;
using Borland.Eco.Windows.Forms;
using Borland.Eco.WinForm;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.UmlRt;
using Borland.Eco.Services;
using Borland.Eco.AutoContainers;

namespace Borland.Eco.Diagnostics
{
	internal class OclEditorPlugin: IHasEditableExpression, IStaticContext
	{
		private ClassAndOclDebuggerPanel d;
		public OclEditorPlugin(ClassAndOclDebuggerPanel d)
		{
			this.d = d;
		}

		public string Expression
		{
			get { return d.tbOclExpression.Text; }
			set { d.tbOclExpression.Text = value; }
		}

		ExpressionKind IHasEditableExpression.ExpressionKind
		{
			get
			{
				return d.ExpressionIsAction ? ExpressionKind.EcoActionLanguage : ExpressionKind.Ocl;
			}
		}
		IStaticContext IHasEditableExpression.StaticContext
		{
			get { return this; }
		}

		IEcoTypeSystem IStaticContext.TypeSystem
		{
			get { return d.TypeSystemService.TypeSystem;}
		}

		IOclTypeService IStaticContext.OclTypeService
		{
			get	{ return d.OclService; }
		}

		IOclPsTypeService IStaticContext.OclPsTypeService
		{
			get	{ return d.OclPsService; }
		}

		IActionLanguageTypeService IStaticContext.ActionLanguageTypeService
		{
			get	{ return d.ActionService; }
		}

		IExternalVariableList IStaticContext.VariableList
		{
			get { return null; }
		}

		IClassifier IStaticContext.StaticUmlType
		{
			get
			{
				return d.cbUseContext.Checked ? d.ActiveClass() : null;
			}
		}
	}
	/// <summary>
	/// Summary description for EcoWinForm.
	/// </summary>
	public class ClassAndOclDebuggerPanel : System.Windows.Forms.Form, IEcoSpaceDebuggerPanel
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.Panel panel1;
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private Borland.Eco.Handles.ExpressionHandle ehAllInstances;
		private Borland.Eco.WinForm.EcoActionExtender EcoGlobalActions;
		private Borland.Eco.WinForm.EcoDragDropExtender EcoDragDrop;
		private Borland.Eco.WinForm.EcoAutoFormExtender EcoAutoForms;
		private Borland.Eco.WinForm.EcoListActionExtender EcoListActions;
		private System.Windows.Forms.TreeView tvClassTree;
		private System.Windows.Forms.ListBox lbClassList;
		private System.Windows.Forms.DataGrid dgAllInstances;
		private System.Windows.Forms.Button btnAdd;
		private System.Windows.Forms.Button btnDelete;
		private System.Windows.Forms.Button btnReload;
		private System.Windows.Forms.ContextMenu cmToggleClassList;
		private System.Windows.Forms.MenuItem mnuShowListView;
		private System.Windows.Forms.MenuItem mnuShowTreeView;
		protected internal System.Windows.Forms.TextBox tbOclExpression;
		private System.Windows.Forms.Button btnOclEditor;
		private System.Windows.Forms.CheckBox cbOclInPS;
		private System.Windows.Forms.Button btnExecuteOcl;
		private Borland.Eco.Handles.ExpressionHandle ehOcl;
		private Borland.Eco.Handles.OclPSHandle pshOcl;
		private System.Windows.Forms.DataGrid dgOcl;
		protected internal System.Windows.Forms.CheckBox cbUseContext;
		private Borland.Eco.Handles.CurrencyManagerHandle cmhAllInstances;
		private System.Windows.Forms.TextBox tbOclMessages;
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.Panel panel3;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.CheckBox cbAction;
		private System.Windows.Forms.ToolTip toolTip1;

		public ClassAndOclDebuggerPanel()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		#region Form setup code
		private void InitializeClasses()
		{
			IClass c;
			for (int i = 0; i < EcoSpace.TypeSystem.AllClasses.Count; i++)
			{
				c = EcoSpace.TypeSystem.AllClasses[i] as IClass;
				lbClassList.Items.Add(c.Name);
			}
			c = EcoSpace.TypeSystem.AllClasses[0] as IClass;
			RecurseSubClasses(c, tvClassTree.Nodes);
		}
		private void RecurseSubClasses(IClass c, TreeNodeCollection nodelist)
		{
			TreeNode node = new TreeNode(c.Name);
			nodelist.Add(node);
			for (int i = 0; i < c.SubTypes.Count; i++)
			{
				RecurseSubClasses(c.SubTypes[i] as IClass, node.Nodes);
			}
		}
		#endregion

		#region Services
		public IPersistenceService PersistenceService
		{
			get	{ return (IPersistenceService)EcoSpace.GetEcoService(typeof(IPersistenceService)); }
		}
		public IDirtyListService DirtyListService
		{
			get { return (IDirtyListService)EcoSpace.GetEcoService(typeof(IDirtyListService)); }
		}

		public IUndoService UndoService
		{
			get { return (IUndoService)EcoSpace.GetEcoService(typeof(IUndoService)); }
		}

		public ITypeSystemService TypeSystemService
		{
			get	{ return (ITypeSystemService)EcoSpace.GetEcoService(typeof(ITypeSystemService)); }
		}
		public ITypeService ActiveExpressionService
		{
			get
			{
				if (ExpressionIsAction)
					return ActionService;
				else
					return OclService;
			}
		}

		public IOclService OclService
		{
			get { return (IOclService)EcoSpace.GetEcoService(typeof(IOclService)); }
		}

		public IOclPsService OclPsService
		{
			get { return (IOclPsService)EcoSpace.GetEcoService(typeof(IOclPsService)); }
		}

		public IActionLanguageService ActionService
		{
			get { return (IActionLanguageService)EcoSpace.GetEcoService(typeof(IActionLanguageService)); }
		}
		public bool ExpressionIsAction { get { return cbAction.Checked;}}
		public IObjectFactoryService ObjectFactoryService
		{
			get	{ return (IObjectFactoryService)EcoSpace.GetEcoService(typeof(IObjectFactoryService)); }
		}
		public IVariableFactoryService VariableFactoryService
		{
			get { return (IVariableFactoryService)EcoSpace.GetEcoService(typeof(IVariableFactoryService)); }
		}
		public IExtentService ExtentService
		{
			get { return (IExtentService)EcoSpace.GetEcoService(typeof(IExtentService)); }
		}
		#endregion

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ClassAndOclDebuggerPanel));
			this.panel1 = new System.Windows.Forms.Panel();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.panel3 = new System.Windows.Forms.Panel();
			this.dgAllInstances = new System.Windows.Forms.DataGrid();
			this.ehAllInstances = new Borland.Eco.Handles.ExpressionHandle();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.btnReload = new System.Windows.Forms.Button();
			this.lbClassList = new System.Windows.Forms.ListBox();
			this.cmToggleClassList = new System.Windows.Forms.ContextMenu();
			this.mnuShowListView = new System.Windows.Forms.MenuItem();
			this.mnuShowTreeView = new System.Windows.Forms.MenuItem();
			this.btnDelete = new System.Windows.Forms.Button();
			this.btnAdd = new System.Windows.Forms.Button();
			this.tvClassTree = new System.Windows.Forms.TreeView();
			this.panel2 = new System.Windows.Forms.Panel();
			this.cbAction = new System.Windows.Forms.CheckBox();
			this.cbOclInPS = new System.Windows.Forms.CheckBox();
			this.dgOcl = new System.Windows.Forms.DataGrid();
			this.tbOclMessages = new System.Windows.Forms.TextBox();
			this.tbOclExpression = new System.Windows.Forms.TextBox();
			this.btnExecuteOcl = new System.Windows.Forms.Button();
			this.cbUseContext = new System.Windows.Forms.CheckBox();
			this.btnOclEditor = new System.Windows.Forms.Button();
			this.EcoAutoForms = new Borland.Eco.WinForm.EcoAutoFormExtender();
			this.EcoDragDrop = new Borland.Eco.WinForm.EcoDragDropExtender();
			this.EcoGlobalActions = new Borland.Eco.WinForm.EcoActionExtender();
			this.pshOcl = new Borland.Eco.Handles.OclPSHandle();
			this.cmhAllInstances = new Borland.Eco.Handles.CurrencyManagerHandle();
			this.EcoListActions = new Borland.Eco.WinForm.EcoListActionExtender();
			this.ehOcl = new Borland.Eco.Handles.ExpressionHandle();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.panel1.SuspendLayout();
			this.panel3.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.dgAllInstances)).BeginInit();
			this.panel2.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.dgOcl)).BeginInit();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.AccessibleDescription = resources.GetString("panel1.AccessibleDescription");
			this.panel1.AccessibleName = resources.GetString("panel1.AccessibleName");
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel1.Anchor")));
			this.panel1.AutoScroll = ((bool)(resources.GetObject("panel1.AutoScroll")));
			this.panel1.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMargin")));
			this.panel1.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMinSize")));
			this.panel1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel1.BackgroundImage")));
			this.panel1.Controls.Add(this.splitter1);
			this.panel1.Controls.Add(this.panel3);
			this.panel1.Controls.Add(this.panel2);
			this.panel1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel1.Dock")));
			this.panel1.Enabled = ((bool)(resources.GetObject("panel1.Enabled")));
			this.panel1.Font = ((System.Drawing.Font)(resources.GetObject("panel1.Font")));
			this.panel1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel1.ImeMode")));
			this.panel1.Location = ((System.Drawing.Point)(resources.GetObject("panel1.Location")));
			this.panel1.Name = "panel1";
			this.panel1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel1.RightToLeft")));
			this.panel1.Size = ((System.Drawing.Size)(resources.GetObject("panel1.Size")));
			this.panel1.TabIndex = ((int)(resources.GetObject("panel1.TabIndex")));
			this.panel1.Text = resources.GetString("panel1.Text");
			this.toolTip1.SetToolTip(this.panel1, resources.GetString("panel1.ToolTip"));
			this.panel1.Visible = ((bool)(resources.GetObject("panel1.Visible")));
			// 
			// splitter1
			// 
			this.splitter1.AccessibleDescription = resources.GetString("splitter1.AccessibleDescription");
			this.splitter1.AccessibleName = resources.GetString("splitter1.AccessibleName");
			this.splitter1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("splitter1.Anchor")));
			this.splitter1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("splitter1.BackgroundImage")));
			this.splitter1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.splitter1.Cursor = System.Windows.Forms.Cursors.HSplit;
			this.splitter1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("splitter1.Dock")));
			this.splitter1.Enabled = ((bool)(resources.GetObject("splitter1.Enabled")));
			this.splitter1.Font = ((System.Drawing.Font)(resources.GetObject("splitter1.Font")));
			this.splitter1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("splitter1.ImeMode")));
			this.splitter1.Location = ((System.Drawing.Point)(resources.GetObject("splitter1.Location")));
			this.splitter1.MinExtra = ((int)(resources.GetObject("splitter1.MinExtra")));
			this.splitter1.MinSize = ((int)(resources.GetObject("splitter1.MinSize")));
			this.splitter1.Name = "splitter1";
			this.splitter1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("splitter1.RightToLeft")));
			this.splitter1.Size = ((System.Drawing.Size)(resources.GetObject("splitter1.Size")));
			this.splitter1.TabIndex = ((int)(resources.GetObject("splitter1.TabIndex")));
			this.splitter1.TabStop = false;
			this.toolTip1.SetToolTip(this.splitter1, resources.GetString("splitter1.ToolTip"));
			this.splitter1.Visible = ((bool)(resources.GetObject("splitter1.Visible")));
			// 
			// panel3
			// 
			this.panel3.AccessibleDescription = resources.GetString("panel3.AccessibleDescription");
			this.panel3.AccessibleName = resources.GetString("panel3.AccessibleName");
			this.panel3.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel3.Anchor")));
			this.panel3.AutoScroll = ((bool)(resources.GetObject("panel3.AutoScroll")));
			this.panel3.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel3.AutoScrollMargin")));
			this.panel3.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel3.AutoScrollMinSize")));
			this.panel3.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel3.BackgroundImage")));
			this.panel3.Controls.Add(this.dgAllInstances);
			this.panel3.Controls.Add(this.btnReload);
			this.panel3.Controls.Add(this.lbClassList);
			this.panel3.Controls.Add(this.btnDelete);
			this.panel3.Controls.Add(this.btnAdd);
			this.panel3.Controls.Add(this.tvClassTree);
			this.panel3.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel3.Dock")));
			this.panel3.Enabled = ((bool)(resources.GetObject("panel3.Enabled")));
			this.panel3.Font = ((System.Drawing.Font)(resources.GetObject("panel3.Font")));
			this.panel3.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel3.ImeMode")));
			this.panel3.Location = ((System.Drawing.Point)(resources.GetObject("panel3.Location")));
			this.panel3.Name = "panel3";
			this.panel3.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel3.RightToLeft")));
			this.panel3.Size = ((System.Drawing.Size)(resources.GetObject("panel3.Size")));
			this.panel3.TabIndex = ((int)(resources.GetObject("panel3.TabIndex")));
			this.panel3.Text = resources.GetString("panel3.Text");
			this.toolTip1.SetToolTip(this.panel3, resources.GetString("panel3.ToolTip"));
			this.panel3.Visible = ((bool)(resources.GetObject("panel3.Visible")));
			// 
			// dgAllInstances
			// 
			this.dgAllInstances.AccessibleDescription = resources.GetString("dgAllInstances.AccessibleDescription");
			this.dgAllInstances.AccessibleName = resources.GetString("dgAllInstances.AccessibleName");
			this.dgAllInstances.AllowDrop = true;
			this.dgAllInstances.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("dgAllInstances.Anchor")));
			this.dgAllInstances.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("dgAllInstances.BackgroundImage")));
			this.dgAllInstances.CaptionFont = ((System.Drawing.Font)(resources.GetObject("dgAllInstances.CaptionFont")));
			this.dgAllInstances.CaptionText = resources.GetString("dgAllInstances.CaptionText");
			this.dgAllInstances.DataMember = "";
			this.dgAllInstances.DataSource = this.ehAllInstances;
			this.dgAllInstances.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("dgAllInstances.Dock")));
			this.EcoAutoForms.SetEcoAutoForm(this.dgAllInstances, true);
			this.EcoDragDrop.SetEcoDragSource(this.dgAllInstances, true);
			this.dgAllInstances.Enabled = ((bool)(resources.GetObject("dgAllInstances.Enabled")));
			this.dgAllInstances.Font = ((System.Drawing.Font)(resources.GetObject("dgAllInstances.Font")));
			this.dgAllInstances.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgAllInstances.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("dgAllInstances.ImeMode")));
			this.dgAllInstances.Location = ((System.Drawing.Point)(resources.GetObject("dgAllInstances.Location")));
			this.dgAllInstances.Name = "dgAllInstances";
			this.dgAllInstances.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("dgAllInstances.RightToLeft")));
			this.dgAllInstances.Size = ((System.Drawing.Size)(resources.GetObject("dgAllInstances.Size")));
			this.dgAllInstances.TabIndex = ((int)(resources.GetObject("dgAllInstances.TabIndex")));
			this.toolTip1.SetToolTip(this.dgAllInstances, resources.GetString("dgAllInstances.ToolTip"));
			this.dgAllInstances.Visible = ((bool)(resources.GetObject("dgAllInstances.Visible")));
			// 
			// ehAllInstances
			// 
			this.ehAllInstances.Enabled = false;
			this.ehAllInstances.RootHandle = this.rhRoot;
			// 
			// btnReload
			// 
			this.btnReload.AccessibleDescription = resources.GetString("btnReload.AccessibleDescription");
			this.btnReload.AccessibleName = resources.GetString("btnReload.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnReload, "");
			this.btnReload.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnReload.Anchor")));
			this.btnReload.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnReload.BackgroundImage")));
			this.EcoListActions.SetBindingContext(this.btnReload, this.dgAllInstances);
			this.btnReload.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnReload.Dock")));
			this.EcoListActions.SetEcoListAction(this.btnReload, Borland.Eco.WinForm.ListAction.Reload);
			this.btnReload.Enabled = ((bool)(resources.GetObject("btnReload.Enabled")));
			this.btnReload.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnReload.FlatStyle")));
			this.btnReload.Font = ((System.Drawing.Font)(resources.GetObject("btnReload.Font")));
			this.btnReload.Image = ((System.Drawing.Image)(resources.GetObject("btnReload.Image")));
			this.btnReload.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnReload.ImageAlign")));
			this.btnReload.ImageIndex = ((int)(resources.GetObject("btnReload.ImageIndex")));
			this.btnReload.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnReload.ImeMode")));
			this.btnReload.Location = ((System.Drawing.Point)(resources.GetObject("btnReload.Location")));
			this.btnReload.Name = "btnReload";
			this.btnReload.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnReload.RightToLeft")));
			this.EcoListActions.SetRootHandle(this.btnReload, this.ehAllInstances);
			this.btnReload.Size = ((System.Drawing.Size)(resources.GetObject("btnReload.Size")));
			this.btnReload.TabIndex = ((int)(resources.GetObject("btnReload.TabIndex")));
			this.btnReload.Text = resources.GetString("btnReload.Text");
			this.btnReload.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnReload.TextAlign")));
			this.toolTip1.SetToolTip(this.btnReload, resources.GetString("btnReload.ToolTip"));
			this.btnReload.Visible = ((bool)(resources.GetObject("btnReload.Visible")));
			// 
			// lbClassList
			// 
			this.lbClassList.AccessibleDescription = resources.GetString("lbClassList.AccessibleDescription");
			this.lbClassList.AccessibleName = resources.GetString("lbClassList.AccessibleName");
			this.lbClassList.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lbClassList.Anchor")));
			this.lbClassList.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("lbClassList.BackgroundImage")));
			this.lbClassList.ColumnWidth = ((int)(resources.GetObject("lbClassList.ColumnWidth")));
			this.lbClassList.ContextMenu = this.cmToggleClassList;
			this.lbClassList.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lbClassList.Dock")));
			this.lbClassList.Enabled = ((bool)(resources.GetObject("lbClassList.Enabled")));
			this.lbClassList.Font = ((System.Drawing.Font)(resources.GetObject("lbClassList.Font")));
			this.lbClassList.HorizontalExtent = ((int)(resources.GetObject("lbClassList.HorizontalExtent")));
			this.lbClassList.HorizontalScrollbar = ((bool)(resources.GetObject("lbClassList.HorizontalScrollbar")));
			this.lbClassList.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lbClassList.ImeMode")));
			this.lbClassList.IntegralHeight = ((bool)(resources.GetObject("lbClassList.IntegralHeight")));
			this.lbClassList.ItemHeight = ((int)(resources.GetObject("lbClassList.ItemHeight")));
			this.lbClassList.Location = ((System.Drawing.Point)(resources.GetObject("lbClassList.Location")));
			this.lbClassList.Name = "lbClassList";
			this.lbClassList.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lbClassList.RightToLeft")));
			this.lbClassList.ScrollAlwaysVisible = ((bool)(resources.GetObject("lbClassList.ScrollAlwaysVisible")));
			this.lbClassList.Size = ((System.Drawing.Size)(resources.GetObject("lbClassList.Size")));
			this.lbClassList.Sorted = true;
			this.lbClassList.TabIndex = ((int)(resources.GetObject("lbClassList.TabIndex")));
			this.toolTip1.SetToolTip(this.lbClassList, resources.GetString("lbClassList.ToolTip"));
			this.lbClassList.Visible = ((bool)(resources.GetObject("lbClassList.Visible")));
			this.lbClassList.DoubleClick += new System.EventHandler(this.classSelector_DoubleClick);
			// 
			// cmToggleClassList
			// 
			this.cmToggleClassList.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.mnuShowListView,
						this.mnuShowTreeView});
			this.cmToggleClassList.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmToggleClassList.RightToLeft")));
			// 
			// mnuShowListView
			// 
			this.mnuShowListView.Enabled = ((bool)(resources.GetObject("mnuShowListView.Enabled")));
			this.mnuShowListView.Index = 0;
			this.mnuShowListView.Shortcut = ((System.Windows.Forms.Shortcut)(resources.GetObject("mnuShowListView.Shortcut")));
			this.mnuShowListView.ShowShortcut = ((bool)(resources.GetObject("mnuShowListView.ShowShortcut")));
			this.mnuShowListView.Text = resources.GetString("mnuShowListView.Text");
			this.mnuShowListView.Visible = ((bool)(resources.GetObject("mnuShowListView.Visible")));
			this.mnuShowListView.Click += new System.EventHandler(this.menuItem1_Click);
			// 
			// mnuShowTreeView
			// 
			this.mnuShowTreeView.Enabled = ((bool)(resources.GetObject("mnuShowTreeView.Enabled")));
			this.mnuShowTreeView.Index = 1;
			this.mnuShowTreeView.Shortcut = ((System.Windows.Forms.Shortcut)(resources.GetObject("mnuShowTreeView.Shortcut")));
			this.mnuShowTreeView.ShowShortcut = ((bool)(resources.GetObject("mnuShowTreeView.ShowShortcut")));
			this.mnuShowTreeView.Text = resources.GetString("mnuShowTreeView.Text");
			this.mnuShowTreeView.Visible = ((bool)(resources.GetObject("mnuShowTreeView.Visible")));
			this.mnuShowTreeView.Click += new System.EventHandler(this.mnuShowTreeView_Click);
			// 
			// btnDelete
			// 
			this.btnDelete.AccessibleDescription = resources.GetString("btnDelete.AccessibleDescription");
			this.btnDelete.AccessibleName = resources.GetString("btnDelete.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnDelete, "");
			this.btnDelete.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnDelete.Anchor")));
			this.btnDelete.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnDelete.BackgroundImage")));
			this.EcoListActions.SetBindingContext(this.btnDelete, this.dgAllInstances);
			this.btnDelete.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnDelete.Dock")));
			this.EcoListActions.SetEcoListAction(this.btnDelete, Borland.Eco.WinForm.ListAction.Delete);
			this.btnDelete.Enabled = ((bool)(resources.GetObject("btnDelete.Enabled")));
			this.btnDelete.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnDelete.FlatStyle")));
			this.btnDelete.Font = ((System.Drawing.Font)(resources.GetObject("btnDelete.Font")));
			this.btnDelete.Image = ((System.Drawing.Image)(resources.GetObject("btnDelete.Image")));
			this.btnDelete.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnDelete.ImageAlign")));
			this.btnDelete.ImageIndex = ((int)(resources.GetObject("btnDelete.ImageIndex")));
			this.btnDelete.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnDelete.ImeMode")));
			this.btnDelete.Location = ((System.Drawing.Point)(resources.GetObject("btnDelete.Location")));
			this.btnDelete.Name = "btnDelete";
			this.btnDelete.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnDelete.RightToLeft")));
			this.EcoListActions.SetRootHandle(this.btnDelete, this.ehAllInstances);
			this.btnDelete.Size = ((System.Drawing.Size)(resources.GetObject("btnDelete.Size")));
			this.btnDelete.TabIndex = ((int)(resources.GetObject("btnDelete.TabIndex")));
			this.btnDelete.Text = resources.GetString("btnDelete.Text");
			this.btnDelete.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnDelete.TextAlign")));
			this.toolTip1.SetToolTip(this.btnDelete, resources.GetString("btnDelete.ToolTip"));
			this.btnDelete.Visible = ((bool)(resources.GetObject("btnDelete.Visible")));
			// 
			// btnAdd
			// 
			this.btnAdd.AccessibleDescription = resources.GetString("btnAdd.AccessibleDescription");
			this.btnAdd.AccessibleName = resources.GetString("btnAdd.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnAdd, "");
			this.btnAdd.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnAdd.Anchor")));
			this.btnAdd.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnAdd.BackgroundImage")));
			this.EcoListActions.SetBindingContext(this.btnAdd, this.dgAllInstances);
			this.btnAdd.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnAdd.Dock")));
			this.EcoListActions.SetEcoListAction(this.btnAdd, Borland.Eco.WinForm.ListAction.Add);
			this.btnAdd.Enabled = ((bool)(resources.GetObject("btnAdd.Enabled")));
			this.btnAdd.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnAdd.FlatStyle")));
			this.btnAdd.Font = ((System.Drawing.Font)(resources.GetObject("btnAdd.Font")));
			this.btnAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAdd.Image")));
			this.btnAdd.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnAdd.ImageAlign")));
			this.btnAdd.ImageIndex = ((int)(resources.GetObject("btnAdd.ImageIndex")));
			this.btnAdd.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnAdd.ImeMode")));
			this.btnAdd.Location = ((System.Drawing.Point)(resources.GetObject("btnAdd.Location")));
			this.btnAdd.Name = "btnAdd";
			this.btnAdd.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnAdd.RightToLeft")));
			this.EcoListActions.SetRootHandle(this.btnAdd, this.ehAllInstances);
			this.btnAdd.Size = ((System.Drawing.Size)(resources.GetObject("btnAdd.Size")));
			this.btnAdd.TabIndex = ((int)(resources.GetObject("btnAdd.TabIndex")));
			this.btnAdd.Text = resources.GetString("btnAdd.Text");
			this.btnAdd.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnAdd.TextAlign")));
			this.toolTip1.SetToolTip(this.btnAdd, resources.GetString("btnAdd.ToolTip"));
			this.btnAdd.Visible = ((bool)(resources.GetObject("btnAdd.Visible")));
			// 
			// tvClassTree
			// 
			this.tvClassTree.AccessibleDescription = resources.GetString("tvClassTree.AccessibleDescription");
			this.tvClassTree.AccessibleName = resources.GetString("tvClassTree.AccessibleName");
			this.tvClassTree.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tvClassTree.Anchor")));
			this.tvClassTree.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tvClassTree.BackgroundImage")));
			this.tvClassTree.ContextMenu = this.cmToggleClassList;
			this.tvClassTree.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tvClassTree.Dock")));
			this.tvClassTree.Enabled = ((bool)(resources.GetObject("tvClassTree.Enabled")));
			this.tvClassTree.Font = ((System.Drawing.Font)(resources.GetObject("tvClassTree.Font")));
			this.tvClassTree.ImageIndex = ((int)(resources.GetObject("tvClassTree.ImageIndex")));
			this.tvClassTree.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tvClassTree.ImeMode")));
			this.tvClassTree.Indent = ((int)(resources.GetObject("tvClassTree.Indent")));
			this.tvClassTree.ItemHeight = ((int)(resources.GetObject("tvClassTree.ItemHeight")));
			this.tvClassTree.Location = ((System.Drawing.Point)(resources.GetObject("tvClassTree.Location")));
			this.tvClassTree.Name = "tvClassTree";
			this.tvClassTree.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tvClassTree.RightToLeft")));
			this.tvClassTree.SelectedImageIndex = ((int)(resources.GetObject("tvClassTree.SelectedImageIndex")));
			this.tvClassTree.Size = ((System.Drawing.Size)(resources.GetObject("tvClassTree.Size")));
			this.tvClassTree.Sorted = true;
			this.tvClassTree.TabIndex = ((int)(resources.GetObject("tvClassTree.TabIndex")));
			this.tvClassTree.Text = resources.GetString("tvClassTree.Text");
			this.toolTip1.SetToolTip(this.tvClassTree, resources.GetString("tvClassTree.ToolTip"));
			this.tvClassTree.Visible = ((bool)(resources.GetObject("tvClassTree.Visible")));
			this.tvClassTree.DoubleClick += new System.EventHandler(this.classSelector_DoubleClick);
			// 
			// panel2
			// 
			this.panel2.AccessibleDescription = resources.GetString("panel2.AccessibleDescription");
			this.panel2.AccessibleName = resources.GetString("panel2.AccessibleName");
			this.panel2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel2.Anchor")));
			this.panel2.AutoScroll = ((bool)(resources.GetObject("panel2.AutoScroll")));
			this.panel2.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel2.AutoScrollMargin")));
			this.panel2.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel2.AutoScrollMinSize")));
			this.panel2.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel2.BackgroundImage")));
			this.panel2.Controls.Add(this.cbAction);
			this.panel2.Controls.Add(this.cbOclInPS);
			this.panel2.Controls.Add(this.dgOcl);
			this.panel2.Controls.Add(this.tbOclMessages);
			this.panel2.Controls.Add(this.tbOclExpression);
			this.panel2.Controls.Add(this.btnExecuteOcl);
			this.panel2.Controls.Add(this.cbUseContext);
			this.panel2.Controls.Add(this.btnOclEditor);
			this.panel2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel2.Dock")));
			this.panel2.Enabled = ((bool)(resources.GetObject("panel2.Enabled")));
			this.panel2.Font = ((System.Drawing.Font)(resources.GetObject("panel2.Font")));
			this.panel2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel2.ImeMode")));
			this.panel2.Location = ((System.Drawing.Point)(resources.GetObject("panel2.Location")));
			this.panel2.Name = "panel2";
			this.panel2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel2.RightToLeft")));
			this.panel2.Size = ((System.Drawing.Size)(resources.GetObject("panel2.Size")));
			this.panel2.TabIndex = ((int)(resources.GetObject("panel2.TabIndex")));
			this.panel2.Text = resources.GetString("panel2.Text");
			this.toolTip1.SetToolTip(this.panel2, resources.GetString("panel2.ToolTip"));
			this.panel2.Visible = ((bool)(resources.GetObject("panel2.Visible")));
			// 
			// cbAction
			// 
			this.cbAction.AccessibleDescription = resources.GetString("cbAction.AccessibleDescription");
			this.cbAction.AccessibleName = resources.GetString("cbAction.AccessibleName");
			this.cbAction.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cbAction.Anchor")));
			this.cbAction.Appearance = ((System.Windows.Forms.Appearance)(resources.GetObject("cbAction.Appearance")));
			this.cbAction.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cbAction.BackgroundImage")));
			this.cbAction.CheckAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cbAction.CheckAlign")));
			this.cbAction.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cbAction.Dock")));
			this.cbAction.Enabled = ((bool)(resources.GetObject("cbAction.Enabled")));
			this.cbAction.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("cbAction.FlatStyle")));
			this.cbAction.Font = ((System.Drawing.Font)(resources.GetObject("cbAction.Font")));
			this.cbAction.Image = ((System.Drawing.Image)(resources.GetObject("cbAction.Image")));
			this.cbAction.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cbAction.ImageAlign")));
			this.cbAction.ImageIndex = ((int)(resources.GetObject("cbAction.ImageIndex")));
			this.cbAction.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cbAction.ImeMode")));
			this.cbAction.Location = ((System.Drawing.Point)(resources.GetObject("cbAction.Location")));
			this.cbAction.Name = "cbAction";
			this.cbAction.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cbAction.RightToLeft")));
			this.cbAction.Size = ((System.Drawing.Size)(resources.GetObject("cbAction.Size")));
			this.cbAction.TabIndex = ((int)(resources.GetObject("cbAction.TabIndex")));
			this.cbAction.Text = resources.GetString("cbAction.Text");
			this.cbAction.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cbAction.TextAlign")));
			this.toolTip1.SetToolTip(this.cbAction, resources.GetString("cbAction.ToolTip"));
			this.cbAction.Visible = ((bool)(resources.GetObject("cbAction.Visible")));
			this.cbAction.CheckedChanged += new System.EventHandler(this.cbAction_CheckedChanged);
			// 
			// cbOclInPS
			// 
			this.cbOclInPS.AccessibleDescription = resources.GetString("cbOclInPS.AccessibleDescription");
			this.cbOclInPS.AccessibleName = resources.GetString("cbOclInPS.AccessibleName");
			this.cbOclInPS.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cbOclInPS.Anchor")));
			this.cbOclInPS.Appearance = ((System.Windows.Forms.Appearance)(resources.GetObject("cbOclInPS.Appearance")));
			this.cbOclInPS.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cbOclInPS.BackgroundImage")));
			this.cbOclInPS.CheckAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cbOclInPS.CheckAlign")));
			this.cbOclInPS.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cbOclInPS.Dock")));
			this.cbOclInPS.Enabled = ((bool)(resources.GetObject("cbOclInPS.Enabled")));
			this.cbOclInPS.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("cbOclInPS.FlatStyle")));
			this.cbOclInPS.Font = ((System.Drawing.Font)(resources.GetObject("cbOclInPS.Font")));
			this.cbOclInPS.Image = ((System.Drawing.Image)(resources.GetObject("cbOclInPS.Image")));
			this.cbOclInPS.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cbOclInPS.ImageAlign")));
			this.cbOclInPS.ImageIndex = ((int)(resources.GetObject("cbOclInPS.ImageIndex")));
			this.cbOclInPS.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cbOclInPS.ImeMode")));
			this.cbOclInPS.Location = ((System.Drawing.Point)(resources.GetObject("cbOclInPS.Location")));
			this.cbOclInPS.Name = "cbOclInPS";
			this.cbOclInPS.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cbOclInPS.RightToLeft")));
			this.cbOclInPS.Size = ((System.Drawing.Size)(resources.GetObject("cbOclInPS.Size")));
			this.cbOclInPS.TabIndex = ((int)(resources.GetObject("cbOclInPS.TabIndex")));
			this.cbOclInPS.Text = resources.GetString("cbOclInPS.Text");
			this.cbOclInPS.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cbOclInPS.TextAlign")));
			this.toolTip1.SetToolTip(this.cbOclInPS, resources.GetString("cbOclInPS.ToolTip"));
			this.cbOclInPS.Visible = ((bool)(resources.GetObject("cbOclInPS.Visible")));
			// 
			// dgOcl
			// 
			this.dgOcl.AccessibleDescription = resources.GetString("dgOcl.AccessibleDescription");
			this.dgOcl.AccessibleName = resources.GetString("dgOcl.AccessibleName");
			this.dgOcl.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("dgOcl.Anchor")));
			this.dgOcl.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("dgOcl.BackgroundImage")));
			this.dgOcl.CaptionFont = ((System.Drawing.Font)(resources.GetObject("dgOcl.CaptionFont")));
			this.dgOcl.CaptionText = resources.GetString("dgOcl.CaptionText");
			this.dgOcl.DataMember = "";
			this.dgOcl.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("dgOcl.Dock")));
			this.EcoAutoForms.SetEcoAutoForm(this.dgOcl, true);
			this.EcoDragDrop.SetEcoDragSource(this.dgOcl, true);
			this.dgOcl.Enabled = ((bool)(resources.GetObject("dgOcl.Enabled")));
			this.dgOcl.Font = ((System.Drawing.Font)(resources.GetObject("dgOcl.Font")));
			this.dgOcl.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgOcl.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("dgOcl.ImeMode")));
			this.dgOcl.Location = ((System.Drawing.Point)(resources.GetObject("dgOcl.Location")));
			this.dgOcl.Name = "dgOcl";
			this.dgOcl.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("dgOcl.RightToLeft")));
			this.dgOcl.Size = ((System.Drawing.Size)(resources.GetObject("dgOcl.Size")));
			this.dgOcl.TabIndex = ((int)(resources.GetObject("dgOcl.TabIndex")));
			this.toolTip1.SetToolTip(this.dgOcl, resources.GetString("dgOcl.ToolTip"));
			this.dgOcl.Visible = ((bool)(resources.GetObject("dgOcl.Visible")));
			// 
			// tbOclMessages
			// 
			this.tbOclMessages.AccessibleDescription = resources.GetString("tbOclMessages.AccessibleDescription");
			this.tbOclMessages.AccessibleName = resources.GetString("tbOclMessages.AccessibleName");
			this.tbOclMessages.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tbOclMessages.Anchor")));
			this.tbOclMessages.AutoSize = ((bool)(resources.GetObject("tbOclMessages.AutoSize")));
			this.tbOclMessages.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tbOclMessages.BackgroundImage")));
			this.tbOclMessages.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tbOclMessages.Dock")));
			this.tbOclMessages.Enabled = ((bool)(resources.GetObject("tbOclMessages.Enabled")));
			this.tbOclMessages.Font = ((System.Drawing.Font)(resources.GetObject("tbOclMessages.Font")));
			this.tbOclMessages.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tbOclMessages.ImeMode")));
			this.tbOclMessages.Location = ((System.Drawing.Point)(resources.GetObject("tbOclMessages.Location")));
			this.tbOclMessages.MaxLength = ((int)(resources.GetObject("tbOclMessages.MaxLength")));
			this.tbOclMessages.Multiline = ((bool)(resources.GetObject("tbOclMessages.Multiline")));
			this.tbOclMessages.Name = "tbOclMessages";
			this.tbOclMessages.PasswordChar = ((char)(resources.GetObject("tbOclMessages.PasswordChar")));
			this.tbOclMessages.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tbOclMessages.RightToLeft")));
			this.tbOclMessages.ScrollBars = ((System.Windows.Forms.ScrollBars)(resources.GetObject("tbOclMessages.ScrollBars")));
			this.tbOclMessages.Size = ((System.Drawing.Size)(resources.GetObject("tbOclMessages.Size")));
			this.tbOclMessages.TabIndex = ((int)(resources.GetObject("tbOclMessages.TabIndex")));
			this.tbOclMessages.Text = resources.GetString("tbOclMessages.Text");
			this.tbOclMessages.TextAlign = ((System.Windows.Forms.HorizontalAlignment)(resources.GetObject("tbOclMessages.TextAlign")));
			this.toolTip1.SetToolTip(this.tbOclMessages, resources.GetString("tbOclMessages.ToolTip"));
			this.tbOclMessages.Visible = ((bool)(resources.GetObject("tbOclMessages.Visible")));
			this.tbOclMessages.WordWrap = ((bool)(resources.GetObject("tbOclMessages.WordWrap")));
			// 
			// tbOclExpression
			// 
			this.tbOclExpression.AccessibleDescription = resources.GetString("tbOclExpression.AccessibleDescription");
			this.tbOclExpression.AccessibleName = resources.GetString("tbOclExpression.AccessibleName");
			this.tbOclExpression.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tbOclExpression.Anchor")));
			this.tbOclExpression.AutoSize = ((bool)(resources.GetObject("tbOclExpression.AutoSize")));
			this.tbOclExpression.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tbOclExpression.BackgroundImage")));
			this.tbOclExpression.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tbOclExpression.Dock")));
			this.tbOclExpression.Enabled = ((bool)(resources.GetObject("tbOclExpression.Enabled")));
			this.tbOclExpression.Font = ((System.Drawing.Font)(resources.GetObject("tbOclExpression.Font")));
			this.tbOclExpression.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tbOclExpression.ImeMode")));
			this.tbOclExpression.Location = ((System.Drawing.Point)(resources.GetObject("tbOclExpression.Location")));
			this.tbOclExpression.MaxLength = ((int)(resources.GetObject("tbOclExpression.MaxLength")));
			this.tbOclExpression.Multiline = ((bool)(resources.GetObject("tbOclExpression.Multiline")));
			this.tbOclExpression.Name = "tbOclExpression";
			this.tbOclExpression.PasswordChar = ((char)(resources.GetObject("tbOclExpression.PasswordChar")));
			this.tbOclExpression.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tbOclExpression.RightToLeft")));
			this.tbOclExpression.ScrollBars = ((System.Windows.Forms.ScrollBars)(resources.GetObject("tbOclExpression.ScrollBars")));
			this.tbOclExpression.Size = ((System.Drawing.Size)(resources.GetObject("tbOclExpression.Size")));
			this.tbOclExpression.TabIndex = ((int)(resources.GetObject("tbOclExpression.TabIndex")));
			this.tbOclExpression.Text = resources.GetString("tbOclExpression.Text");
			this.tbOclExpression.TextAlign = ((System.Windows.Forms.HorizontalAlignment)(resources.GetObject("tbOclExpression.TextAlign")));
			this.toolTip1.SetToolTip(this.tbOclExpression, resources.GetString("tbOclExpression.ToolTip"));
			this.tbOclExpression.Visible = ((bool)(resources.GetObject("tbOclExpression.Visible")));
			this.tbOclExpression.WordWrap = ((bool)(resources.GetObject("tbOclExpression.WordWrap")));
			this.tbOclExpression.TextChanged += new System.EventHandler(this.tbOclExpression_TextChanged);
			// 
			// btnExecuteOcl
			// 
			this.btnExecuteOcl.AccessibleDescription = resources.GetString("btnExecuteOcl.AccessibleDescription");
			this.btnExecuteOcl.AccessibleName = resources.GetString("btnExecuteOcl.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnExecuteOcl, "");
			this.btnExecuteOcl.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnExecuteOcl.Anchor")));
			this.btnExecuteOcl.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnExecuteOcl.BackgroundImage")));
			this.btnExecuteOcl.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnExecuteOcl.Dock")));
			this.btnExecuteOcl.Enabled = ((bool)(resources.GetObject("btnExecuteOcl.Enabled")));
			this.btnExecuteOcl.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnExecuteOcl.FlatStyle")));
			this.btnExecuteOcl.Font = ((System.Drawing.Font)(resources.GetObject("btnExecuteOcl.Font")));
			this.btnExecuteOcl.Image = ((System.Drawing.Image)(resources.GetObject("btnExecuteOcl.Image")));
			this.btnExecuteOcl.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnExecuteOcl.ImageAlign")));
			this.btnExecuteOcl.ImageIndex = ((int)(resources.GetObject("btnExecuteOcl.ImageIndex")));
			this.btnExecuteOcl.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnExecuteOcl.ImeMode")));
			this.btnExecuteOcl.Location = ((System.Drawing.Point)(resources.GetObject("btnExecuteOcl.Location")));
			this.btnExecuteOcl.Name = "btnExecuteOcl";
			this.btnExecuteOcl.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnExecuteOcl.RightToLeft")));
			this.btnExecuteOcl.Size = ((System.Drawing.Size)(resources.GetObject("btnExecuteOcl.Size")));
			this.btnExecuteOcl.TabIndex = ((int)(resources.GetObject("btnExecuteOcl.TabIndex")));
			this.btnExecuteOcl.Text = resources.GetString("btnExecuteOcl.Text");
			this.btnExecuteOcl.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnExecuteOcl.TextAlign")));
			this.toolTip1.SetToolTip(this.btnExecuteOcl, resources.GetString("btnExecuteOcl.ToolTip"));
			this.btnExecuteOcl.Visible = ((bool)(resources.GetObject("btnExecuteOcl.Visible")));
			this.btnExecuteOcl.Click += new System.EventHandler(this.btnExecuteOcl_Click);
			// 
			// cbUseContext
			// 
			this.cbUseContext.AccessibleDescription = resources.GetString("cbUseContext.AccessibleDescription");
			this.cbUseContext.AccessibleName = resources.GetString("cbUseContext.AccessibleName");
			this.cbUseContext.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cbUseContext.Anchor")));
			this.cbUseContext.Appearance = ((System.Windows.Forms.Appearance)(resources.GetObject("cbUseContext.Appearance")));
			this.cbUseContext.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cbUseContext.BackgroundImage")));
			this.cbUseContext.CheckAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cbUseContext.CheckAlign")));
			this.cbUseContext.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cbUseContext.Dock")));
			this.cbUseContext.Enabled = ((bool)(resources.GetObject("cbUseContext.Enabled")));
			this.cbUseContext.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("cbUseContext.FlatStyle")));
			this.cbUseContext.Font = ((System.Drawing.Font)(resources.GetObject("cbUseContext.Font")));
			this.cbUseContext.Image = ((System.Drawing.Image)(resources.GetObject("cbUseContext.Image")));
			this.cbUseContext.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cbUseContext.ImageAlign")));
			this.cbUseContext.ImageIndex = ((int)(resources.GetObject("cbUseContext.ImageIndex")));
			this.cbUseContext.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cbUseContext.ImeMode")));
			this.cbUseContext.Location = ((System.Drawing.Point)(resources.GetObject("cbUseContext.Location")));
			this.cbUseContext.Name = "cbUseContext";
			this.cbUseContext.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cbUseContext.RightToLeft")));
			this.cbUseContext.Size = ((System.Drawing.Size)(resources.GetObject("cbUseContext.Size")));
			this.cbUseContext.TabIndex = ((int)(resources.GetObject("cbUseContext.TabIndex")));
			this.cbUseContext.Text = resources.GetString("cbUseContext.Text");
			this.cbUseContext.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("cbUseContext.TextAlign")));
			this.toolTip1.SetToolTip(this.cbUseContext, resources.GetString("cbUseContext.ToolTip"));
			this.cbUseContext.Visible = ((bool)(resources.GetObject("cbUseContext.Visible")));
			this.cbUseContext.CheckedChanged += new System.EventHandler(this.cbUseContext_CheckedChanged);
			// 
			// btnOclEditor
			// 
			this.btnOclEditor.AccessibleDescription = resources.GetString("btnOclEditor.AccessibleDescription");
			this.btnOclEditor.AccessibleName = resources.GetString("btnOclEditor.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnOclEditor, "");
			this.btnOclEditor.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnOclEditor.Anchor")));
			this.btnOclEditor.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnOclEditor.BackgroundImage")));
			this.btnOclEditor.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnOclEditor.Dock")));
			this.btnOclEditor.Enabled = ((bool)(resources.GetObject("btnOclEditor.Enabled")));
			this.btnOclEditor.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnOclEditor.FlatStyle")));
			this.btnOclEditor.Font = ((System.Drawing.Font)(resources.GetObject("btnOclEditor.Font")));
			this.btnOclEditor.Image = ((System.Drawing.Image)(resources.GetObject("btnOclEditor.Image")));
			this.btnOclEditor.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnOclEditor.ImageAlign")));
			this.btnOclEditor.ImageIndex = ((int)(resources.GetObject("btnOclEditor.ImageIndex")));
			this.btnOclEditor.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnOclEditor.ImeMode")));
			this.btnOclEditor.Location = ((System.Drawing.Point)(resources.GetObject("btnOclEditor.Location")));
			this.btnOclEditor.Name = "btnOclEditor";
			this.btnOclEditor.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnOclEditor.RightToLeft")));
			this.btnOclEditor.Size = ((System.Drawing.Size)(resources.GetObject("btnOclEditor.Size")));
			this.btnOclEditor.TabIndex = ((int)(resources.GetObject("btnOclEditor.TabIndex")));
			this.btnOclEditor.Text = resources.GetString("btnOclEditor.Text");
			this.btnOclEditor.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnOclEditor.TextAlign")));
			this.toolTip1.SetToolTip(this.btnOclEditor, resources.GetString("btnOclEditor.ToolTip"));
			this.btnOclEditor.Visible = ((bool)(resources.GetObject("btnOclEditor.Visible")));
			this.btnOclEditor.Click += new System.EventHandler(this.btnOclEditor_Click);
			// 
			// EcoAutoForms
			// 
			this.EcoAutoForms.ContainerReusage = Borland.Eco.AutoContainers.ContainerReusage.ReuseForElement;
			// 
			// EcoGlobalActions
			// 
			this.EcoGlobalActions.RootHandle = this.rhRoot;
			// 
			// cmhAllInstances
			// 
			this.cmhAllInstances.BindingContext = this.dgAllInstances;
			this.cmhAllInstances.RootHandle = this.ehAllInstances;
			// 
			// ehOcl
			// 
			this.ehOcl.RootHandle = this.rhRoot;
			// 
			// ClassAndOclDebuggerPanel
			// 
			this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
			this.AccessibleName = resources.GetString("$this.AccessibleName");
			this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
			this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
			this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
			this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
			this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
			this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
			this.Controls.Add(this.panel1);
			this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
			this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
			this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
			this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
			this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
			this.Name = "ClassAndOclDebuggerPanel";
			this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
			this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
			this.Text = resources.GetString("$this.Text");
			this.toolTip1.SetToolTip(this, resources.GetString("$this.ToolTip"));
			this.panel1.ResumeLayout(false);
			this.panel3.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.dgAllInstances)).EndInit();
			this.panel2.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.dgOcl)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		public Borland.Eco.Handles.EcoSpace EcoSpace
		{
			get { return (Borland.Eco.Handles.EcoSpace)rhRoot.EcoSpace; }
			set { rhRoot.EcoSpace = value; }
		}

		private string newExpression = "";

		private void AutoFormForClass(string name)
		{
			ehAllInstances.RootHandle = null;
			newExpression = name+".allInstances";
			dgAllInstances.CaptionText = newExpression;
			ehAllInstances.RootHandle = rhRoot;
			ehAllInstances.Expression = newExpression;
			SetupDefaultColumns(ehAllInstances);
			ehAllInstances.Enabled = true;
			Borland.Eco.Handles.ElementHandle.EnsureAllBindingLists();
		}

		private string CurrentSelectedClassName()
		{
			try
			{
				return tvClassTree.Visible ? tvClassTree.SelectedNode.Text : lbClassList.Items[lbClassList.SelectedIndex].ToString();
			}
			catch (ArgumentOutOfRangeException)
			{
				return string.Empty;
			}
		}

		private string activeClassName;

		internal IClass ActiveClass()
		{
			IClass res = null;
			if (activeClassName != null)
				res = TypeSystemService.TypeSystem.AllClasses.GetItemByName(activeClassName) as IClass;
			return res;
		}

		private void classSelector_DoubleClick(object sender, System.EventArgs e)
		{
			activeClassName = CurrentSelectedClassName();
			if (activeClassName == string.Empty) return;
			btnAdd.Enabled = true;
			btnDelete.Enabled = true;
			btnReload.Enabled = true;
			cbUseContext.Enabled = true;
			toolTip1.SetToolTip(btnAdd, FormsStringRes.sCreateNewInstance(activeClassName));
			if (cbUseContext.Checked)
			{
				ehOcl.RootHandle = null;
			}
			AutoFormForClass(activeClassName);
		}

		private static void SetupDefaultColumns(ElementHandle handle)
		{
			if (handle.Columns.Count == 0)
			{
				OclColumn col1 = new OclColumn();
				col1.Expression = "self.oclType.asString"; // do not localize
				col1.Name = "Type"; // do not localize
				OclColumn col2 = new OclColumn();
				col2.Expression = "self.asString"; // do not localize
				col2.Name = "AsString"; // do not localize
				handle.Columns.AddRange(new AbstractColumn[] {col1, col2});
			}
		}

		private void menuItem1_Click(object sender, System.EventArgs e)
		{
			lbClassList.Visible = true;
			tvClassTree.Visible = false;
		}

		private void mnuShowTreeView_Click(object sender, System.EventArgs e)
		{
			lbClassList.Visible = false;
			tvClassTree.Visible = true;
		}

		private bool ValidateOcl()
		{
			IClassifier context = null;
			if (cbUseContext.Checked)
			{
				context = ActiveClass();
			}
			tbOclMessages.Visible = true;
			dgOcl.Visible = false;

			IClassifier resultType = null;
			try
			{
				resultType = ActiveExpressionService.ExpressionType(tbOclExpression.Text, context, true);
			}
			catch (Exception exception)
			{
				tbOclMessages.Text = exception.ToString();
				return false;
			}
			tbOclMessages.Text = FormsStringRes.sExpressionIsOk;
			
			if (resultType != null)
				tbOclMessages.Text += FormsStringRes.sResultTypeIs(resultType.Name);

			return true;
		}

		private void btnExecuteOcl_Click(object sender, System.EventArgs e)
		{
			if (!ValidateOcl())
			  return;

			if (ExpressionIsAction)
			{
				IElement root = null;
				if (cbUseContext.Checked)
					root = cmhAllInstances.Element;
				try
				{
					ActionService.Execute(root, tbOclExpression.Text);
					tbOclMessages.Text = "Action executed";

				}
				catch (Exception exception)
				{
					tbOclMessages.Text = exception.ToString();
				}
			}
			else
			{
				tbOclMessages.Visible = false;
				dgOcl.Visible = true;

				dgOcl.CaptionVisible = false;
				dgOcl.DataSource = null;
				pshOcl.RootHandle = null;
				pshOcl.Expression = "";
				ehOcl.RootHandle = null;
				ehOcl.Expression = "";
				ElementHandle expressionRoot = rhRoot;
				if (cbUseContext.Checked)
					expressionRoot = cmhAllInstances;

				if (cbOclInPS.Checked)
				{
					SetupDefaultColumns(pshOcl);
					pshOcl.Expression = tbOclExpression.Text;
					pshOcl.RootHandle = expressionRoot;
					pshOcl.Execute();
					dgOcl.DataSource = pshOcl;
				}
				else
				{
					SetupDefaultColumns(ehOcl);
					ehOcl.Expression = tbOclExpression.Text;
					ehOcl.RootHandle = expressionRoot;
					dgOcl.DataSource = ehOcl;
				}
			}
		}

		private void btnOclEditor_Click(object sender, System.EventArgs e)
		{
			IHasEditableExpression editorPlugin = new OclEditorPlugin(this);
			Borland.Eco.Handles.OclEditor.ShowEditor(editorPlugin);
		}

		private void tbOclExpression_TextChanged(object sender, System.EventArgs e)
		{
			ValidateOcl();
		}

		Panel IEcoSpaceDebuggerPanel.Panel { get { return panel1; }}
		string IEcoSpaceDebuggerPanel.Caption { get { return "Classes and Ocl"; }}
		MainMenu IEcoSpaceDebuggerPanel.MainMenu { get { return null; } }
		void IEcoSpaceDebuggerPanel.Init(EcoSpace es)
		{
			this.EcoSpace = es;
			InitializeClasses();

			IClassifier rootClass = TypeSystemService.TypeSystem.AllClasses[0];
			rhRoot.StaticValueTypeName= rootClass.CollectionType.Name;


			// adjust the height of the class selector list/tree
			lbClassList.Height = tvClassTree.Bottom - lbClassList.Top;
			tvClassTree.Top = lbClassList.Top;
			tvClassTree.Height = lbClassList.Height;
			tvClassTree.Visible = false;
			// adjust width of the ocl messages box/result ggrid
			dgOcl.Width = tbOclMessages.Right - dgOcl.Left;
			tbOclMessages.Left = dgOcl.Left;
			tbOclMessages.Width = dgOcl.Width;
			tbOclMessages.Visible = false;
		}

		private void cbAction_CheckedChanged(object sender, System.EventArgs e)
		{
			cbOclInPS.Enabled = !cbAction.Checked;
			btnExecuteOcl.Text = cbAction.Checked?"Exec":"Eval";
			ValidateOcl();
		}
		
		private void cbUseContext_CheckedChanged(object sender, System.EventArgs e)
		{
			ValidateOcl();
		}
	}
}
